/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.entity;

import net.jayjay.dangerzone.entity.EntityLiving;
import net.jayjay.dangerzone.entity.model.ModelBiped;
import net.jayjay.dangerzone.player.Gamemode;
import net.jayjay.dangerzone.texture.Textures;
import net.jayjay.dangerzone.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class EntityPlayer
extends EntityLiving {
    public float timeOffs;
    public float speed;
    private static ModelBiped biped = new ModelBiped();
    public String playerName = "Player";
    public float fov = 70.0f;
    public float rot;
    public float rotA = (float)(Math.random() + 1.0) * 0.01f;
    public boolean crouching;

    public EntityPlayer(World level) {
        super(level);
        this.texture = "/char.png";
        this.setSize(0.8f, 1.6f);
        this.setHealth(100);
        this.heightOffset = 1.62f;
        this.speed = 1.0f;
        this.timeOffs = (float)Math.random() * 1239813.0f;
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.health < 0) {
            this.health = 0;
        }
        float xa = 0.0f;
        float ya = 0.0f;
        if (!this.isDead()) {
            if (Keyboard.isKeyDown(19)) {
                this.resetPos();
            }
            if (Keyboard.isKeyDown(17)) {
                ya -= 1.0f;
            }
            if (Keyboard.isKeyDown(31)) {
                ya += 1.0f;
            }
            if (Keyboard.isKeyDown(30)) {
                xa -= 1.0f;
            }
            if (Keyboard.isKeyDown(32)) {
                xa += 1.0f;
            }
            if (Gamemode.gamemode != 0) {
                if (Keyboard.isKeyDown(57)) {
                    this.yd = 0.2f;
                }
            } else if (Keyboard.isKeyDown(57) && this.onGround) {
                this.yd = 0.5f;
            }
            if (Gamemode.gamemode != 0 && Keyboard.isKeyDown(42)) {
                this.yd = -0.2f;
            }
            if (Keyboard.isKeyDown(29)) {
                this.crouching = true;
                this.heightOffset = 1.5f;
            } else {
                this.crouching = false;
                this.heightOffset = 1.62f;
            }
            this.moveRelative(xa, ya, this.onGround ? 0.1f : 0.02f);
            this.yd = Gamemode.gamemode != 0 ? (float)((double)this.yd - 0.0) : (float)((double)this.yd - 0.08);
            this.move(this.xd, this.yd, this.zd);
            if (this.crouching) {
                this.xd *= 0.455f;
                this.yd *= 0.98f;
                this.zd *= 0.455f;
            } else {
                this.xd *= 0.91f;
                this.yd *= 0.98f;
                this.zd *= 0.91f;
            }
            if (this.onGround) {
                if (this.crouching) {
                    this.xd *= 0.35f;
                    this.zd *= 0.35f;
                } else {
                    this.xd *= 0.7f;
                    this.zd *= 0.7f;
                }
            }
        }
    }

    @Override
    public void render(float a2) {
        GL11.glEnable(3553);
        Textures.bindNearest(this.texture);
        GL11.glPushMatrix();
        double time = (double)System.nanoTime() / 1.0E9 * 10.0 * (double)this.speed + (double)this.timeOffs;
        float size = 0.058333334f;
        float yy = (float)(-Math.abs(Math.sin(time * 0.6662)) * 5.0 - 23.0);
        GL11.glTranslatef(this.xo + (this.x - this.xo) * a2, this.yo + (this.y - this.yo) * a2, this.zo + (this.z - this.zo) * a2);
        GL11.glScalef(1.0f, -1.0f, 1.0f);
        GL11.glScalef(size, size, size);
        GL11.glTranslatef(0.0f, yy, 0.0f);
        biped.render((float)time);
        GL11.glPopMatrix();
        GL11.glDisable(3553);
    }

    public float getEyeHeight() {
        return 1.62f;
    }
}

